// By EVOLVED
// www.evolved-software.com

#include "Settings.fx"

//--------------
// un-tweaks
//--------------
   float4x4 World:World;
   float4x4 ViewProj:ViewProjection; 
   float4x4 ViewInv:ViewInverse;
   float4x4 boneMatrix[50]:BoneMatrixPalette;

//--------------
// tweaks
//--------------
   float4 CameraPosition;
   float4 FogColor;
   float3 FogDensity;
   float4 FogHeight;
   float4 FogHeightColor;
   float3 AmbientSky;
   float3 AmbientGround;
   float3 LightingRange;
   float3 LightingTexture;
   float3 ReflectionColor;
   float3 LightDirection;
   float3 LightDirectionColor;
   float4 ShadowNoise;
   float4 ShadowBlur;
   float3 ShadowBlurSplit;
   float4x4 ShadowProj;
   float3 ShadowDirection;
   float4 ShadowPosition;
   float4 ShadowRanges;
   float4x4 ShadowProjection;
   float3 ShadowProjPos1;
   float3 ShadowProjPos2;
   float3 ShadowProjPos3;
   float3 ShadowPositionX;
   float3 ShadowPositionY;
   float3 ShadowPositionZ;
   float4x4 VarianceShadowProjection;
   float3 VarianceShadowPosition;
   float4 VariancePosition;
   float Normalz;

//--------------
// Textures
//--------------
   texture BaseTexture <string Name = "";>;
   sampler BaseSampler=sampler_state 
      {
         Texture=<BaseTexture>;
  	 MagFilter=anisotropic;
	 MinFilter=anisotropic;
	 MipFilter=anisotropic;
	 MaxAnisotropy=6;
      };
   texture NormalMapTexture <string Name = "";>;	
   sampler NormalMapSampler=sampler_state 
      {
 	 Texture=<NormalMapTexture>;
  	 MagFilter=anisotropic;
	 MinFilter=anisotropic;
	 MipFilter=anisotropic;
	 MaxAnisotropy=2;
      };
   texture SecondarysTexture <string Name = "";>;
   sampler SecondarysSampler=sampler_state
      {
 	 Texture=<SecondarysTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=Linear;
      };
   texture LightTexture <string Name="";>;
   sampler LightSampler=sampler_state
      {
	 Texture=<LightTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
      };
   texture LightDataTexture <string Name = "";>;
   sampler LightDataSampler=sampler_state
      {
 	 Texture=<LightDataTexture>;
  	 MagFilter=None;
	 MinFilter=None;
	 MipFilter=None;
      	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };
   texture Shadow1Texture <string Name = "";>;
   sampler Shadow1Sampler=sampler_state
      {
 	 Texture=<Shadow1Texture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
         AddressU=Border;
         AddressV=Border;
         AddressW=Border;
         BorderColor=16646655;
      };
   texture Shadow2Texture <string Name = "";>;
   sampler Shadow2Sampler=sampler_state
      {
 	 Texture=<Shadow2Texture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };
   texture Shadow3Texture <string Name = "";>;
   sampler Shadow3Sampler=sampler_state
      {
 	 Texture=<Shadow3Texture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
      	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };

//--------------
// Functions
//--------------
   #include "Tile Count.fx"
   #include "Tile Array.fx"
   #include "Diffuse Light.fx"
   #include "Spot Light.fx"
   #if Specularity == 1
    #include "Specular Light.fx"
   #endif
   #include "Vertex Fog.fx"
   #include "Vertex Ambient.fx"
   #if ParallaxMap == 1
    #include "Parallax Mapping.fx"
   #endif
   #include "Reflections.fx"
   #if ParallaxReflection == 1
    #include "Parallax Correction.fx"
   #endif
   #if ShadowsSoft == 1
    #include "Shadow Mapping.fx"
   #endif
   #if TerrainShadows == 1
    #include "Variance Shadow Mapping.fx"
   #endif
   #if Shadows == 0
    #include "Pixel Lighting.fx"
   #else
    #if ShadowsSoft == 0
     #include "Pixel Lighting Shadow.fx"
    #else
     #include "Pixel Lighting Shadow Soft.fx"
    #endif
   #endif

//--------------
// structs 
//--------------
   struct Input
      {
         float4 Pos:POSITION;
         float3 Normal:NORMAL;
         float3 Tangent:TANGENT;
         float4 Blendweight:TEXCOORD1;
         float4 Blendindices:TEXCOORD2;
         float2 Tex0:TEXCOORD0;
      };
   struct Out_Lighting
      {
         float4 Pos:POSITION;
         float3 Tex:TEXCOORD0;
         float4 Project:TEXCOORD1;
         float4 TBNRow1:TEXCOORD2;
         float4 TBNRow2:TEXCOORD3;
         float4 TBNRow3:TEXCOORD4;
         float4 ViewVec:TEXCOORD5;
         float4 WorldPos:TEXCOORD6;
         float3 ViewNormal:TEXCOORD7;
         float4 Ambient:COLOR0;
         float4 Reflect:COLOR1;
      };
   struct Out_Depth
      {
         float4 Pos:POSITION; 
         float2 Tex:TEXCOORD0; 
         float3 Depth:TEXCOORD1;
      };

//--------------
// vertex shader
//--------------
   Out_Lighting VS_Lighting(Input IN) 
      {
         Out_Lighting OUT;
    	 float3 WorldPos=0, Normals=0;
    	 for (int i = 0; i < 3; i++) {
     	  float Index=IN.Blendindices[i];
     	  float3x4 BoneMat=float3x4(boneMatrix[Index][0],boneMatrix[Index][1],boneMatrix[Index][2]);
     	  WorldPos +=(mul(BoneMat,IN.Pos)+boneMatrix[Index][3].xyz)*IN.Blendweight[i];
     	  Normals +=mul(float3x3(BoneMat[0].xyz,BoneMat[1].xyz,BoneMat[2].xyz),IN.Normal)*IN.Blendweight[i];
    	 }
         WorldPos=mul(float4(WorldPos,1),World).xyz;
         Normals=normalize(mul(Normals,World));
         OUT.Pos=mul(float4(WorldPos,1),ViewProj);
         OUT.Project=float4(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5,OUT.Pos.z,OUT.Pos.w);
         OUT.Tex.xy=IN.Tex0;
	 float3 Tangent=normalize(mul(IN.Tangent,World));
         OUT.TBNRow1.xyz=Tangent;
         OUT.TBNRow2.xyz=cross(Normals,Tangent);
         OUT.TBNRow3.xyz=Normals;
         OUT.ViewVec.xyz=ViewInv[3].xyz-WorldPos;
         OUT.WorldPos=float4(WorldPos,0);
         float3 ViewVec=normalize(OUT.ViewVec.xyz);
         float ViewDepth=length(OUT.ViewVec.xyz);
         float3x3 WorldTBN=float3x3(OUT.TBNRow1.xyz,OUT.TBNRow2.xyz,OUT.TBNRow3.xyz);
         OUT.ViewNormal=mul(OUT.ViewVec,transpose(WorldTBN)); 
         OUT.Tex.z=1.0;
         #if Shadows == 1
          #if TerrainShadows == 1
           float2 ShadowProj=float2(0.75,0.5)+mul(float4(WorldPos,1.0),VarianceShadowProjection)*float2(0.25,-0.5);
           float Depth=dot(WorldPos-VarianceShadowPosition,ShadowDirection)/ShadowRanges.w;
           float Edge=saturate(VariancePosition.w-length(WorldPos-VariancePosition.xyz));
           OUT.Tex.z=lerp(1.0,VarianceShadowMapping(ShadowProj,saturate(Depth)),Edge);
          #endif
         #endif
         float4 WorldCamPos=OUT.WorldPos-CameraPosition;
	 float3 AmbientDir=normalize(float3(-LightDirection.x,1.0,-LightDirection.z));
         OUT.Ambient.xyz=lerp(AmbientGround,AmbientSky,0.5+dot(Normals,AmbientDir)*0.5);
         float LightSegment=clamp(floor((ViewDepth/LightingRange.z)*16.0),0.0,15.0)*0.00390625;
         int LightCount=tex2Dlod(LightDataSampler,float4(0.12890625,LightSegment,0.0,0.0));
         float4 AmbientLighting=0.0;
         for (int l=0; l < LightCount; l++) {
          AmbientLighting=max(VertexAmbient((34.0+l)*0.00390625,LightSegment,WorldCamPos),AmbientLighting);
         }
         OUT.Ambient.xyz=lerp(OUT.Ambient.xyz,AmbientLighting.xyz,AmbientLighting.w);
         OUT.Ambient.w=1.0;
         OUT.Reflect.xyz=lerp(ReflectionColor,1.0,AmbientLighting.w);
         OUT.Reflect.w=max((0.5+dot(-LightDirection,Normals)*0.5)*dot(normalize(-LightDirection+ViewVec),ViewVec),0.0);
         float4 Fog=VertexFog(ViewDepth,WorldPos,ViewVec,LightDirection,LightDirectionColor,FogColor,FogDensity,FogHeightColor,FogHeight);
         OUT.TBNRow1.w=Fog.x, OUT.TBNRow2.w=Fog.y, OUT.TBNRow3.w=Fog.z, OUT.ViewVec.w=Fog.w;
         return OUT;
      }
   Out_Depth VS_DepthMapDir(Input IN)
      {
         Out_Depth OUT;
    	 float3 WorldPos=0;
    	 for (int i = 0; i < 3; i++) {
     	  float Index=IN.Blendindices[i];
     	  float3x4 BoneMat=float3x4(boneMatrix[Index][0],boneMatrix[Index][1],boneMatrix[Index][2]);
     	  WorldPos +=(mul(BoneMat,IN.Pos)+boneMatrix[Index][3].xyz)*IN.Blendweight[i];
    	 }
         WorldPos=mul(float4(WorldPos,1),World).xyz;
         OUT.Pos=mul(float4(WorldPos,1.0),ShadowProj);
         OUT.Tex=IN.Tex0;
         OUT.Depth=WorldPos-ShadowPosition.xyz;
         return OUT;
      }
   Out_Depth VS_DepthMap(Input IN)
      {
         Out_Depth OUT;
    	 float3 WorldPos=0;
    	 for (int i = 0; i < 3; i++) {
     	  float Index=IN.Blendindices[i];
     	  float3x4 BoneMat=float3x4(boneMatrix[Index][0],boneMatrix[Index][1],boneMatrix[Index][2]);
     	  WorldPos +=(mul(BoneMat,IN.Pos)+boneMatrix[Index][3].xyz)*IN.Blendweight[i];
    	 }
         WorldPos=mul(float4(WorldPos,1),World).xyz;
         OUT.Pos=mul(float4(WorldPos,1.0),ViewProj);
         OUT.Tex=IN.Tex0;
         OUT.Depth=WorldPos.xyz-ShadowPosition.xyz;
         return OUT;
      }

//--------------
// pixel shader
//--------------
   float4 PS_Lighting(Out_Lighting IN)  : COLOR
      {
         int2 Tiles;
         IN.Project.xy /=IN.Project.w;
         float Noise=frac(52.9829*frac(dot(IN.Project*ShadowNoise.xy,ShadowNoise.zw)));
         float Index=floor(IN.Project.x*16.0)+floor(IN.Project.y*8.0)*16.0;
         float ViewDepth=length(IN.ViewVec.xyz);
         float3 ViewVec=normalize(IN.ViewVec.xyz);
         #if ParallaxMap == 1
          IN.Tex.xy=ParallaxMapping(SecondarysSampler,IN.Tex.xy,IN.ViewNormal);
         #endif
         float4 Diffuse=tex2D(BaseSampler,IN.Tex.xy);
         float4 NormalMap=tex2D(NormalMapSampler,IN.Tex.xy);
         float4 Secondarys=tex2D(SecondarysSampler,IN.Tex.xy);
         Diffuse.xyz=pow(Diffuse.xyz,2.2);
         float3x3 WorldTBN=float3x3(IN.TBNRow1.xyz,IN.TBNRow2.xyz,IN.TBNRow3.xyz);
         float3 Normals=normalize(mul(float3(NormalMap.yw*2.0-1.0,Normalz),WorldTBN));
         float ViewNormal=max(dot(ViewVec,Normals),0.0);
         float3 Specular=lerp(0.04,Diffuse.xyz,NormalMap.x);
         Specular +=(1.0-Specular)*pow(1.0-NormalMap.z,2.2)*pow(1.0-ViewNormal,5.0);
         float Distribution=pow(NormalMap.z*NormalMap.z+0.004,2.0);
         float4 WorldCamPos=IN.WorldPos-CameraPosition;
         float4 BoxMin=float4(-999999.0,-999999.0,-999999.0,LightingTexture.z);
         float4 BoxMax=float4(999999.0,999999.0,999999.0,0.0);
         #if BoxReflection == 1
          Tiles=TileCount(float2(0.0625,0.0)+IN.Project*float2(0.0625,0.03125),ViewDepth/LightingRange.y);
          for(int i=0; i<Tiles.x; i++ ) {
           float TileArray=TileArray(i+224.0,Index,Tiles.y);
           float4 ReflectBoxMin=tex2Dlod(LightDataSampler,float4(TileArray,0.96484375,0.0,0.0))-WorldCamPos;
           float4 ReflectBoxMax=tex2Dlod(LightDataSampler,float4(TileArray,0.96875,0.0,0.0))-WorldCamPos;
           float3 Padding=min(ReflectBoxMax.xyz-Noise*ReflectBoxMax.w,-(ReflectBoxMin.xyz+Noise*ReflectBoxMax.w));
           if(min(min(Padding.x,Padding.y),Padding.z)>0.0) BoxMin=ReflectBoxMin, BoxMax=ReflectBoxMax;
          }
         #endif
         float3 ReflectionVec=reflect(-ViewVec,Normals);
         #if ParallaxReflection == 1
          ReflectionVec=ParallaxCorrection(ReflectionVec,BoxMin.xyz,BoxMax.xyz);
         #endif
         float3 LightSpecular=IN.Reflect.xyz*Reflections(ReflectionVec,NormalMap.z,BoxMin.w);
         float3 Lighting=DiffuseLight(LightDirection,Normals,LightDirectionColor);
         float4 Disk1=0.0, Disk2=0.0, DiskSin=0.0, DiskCos=0.0;
         #if Shadows == 1
          float3 ShadowProjPos[3]={IN.WorldPos.xyz-ShadowProjPos1,IN.WorldPos.xyz-ShadowProjPos2,IN.WorldPos.xyz-ShadowProjPos3};
          float2 Split=float2(length(ShadowProjPos[0].xyz),length(ShadowProjPos[1].xyz))/ShadowRanges.xy*4.0;
          Split=saturate(floor(Split+Noise*0.1));
          int Splits=Split.x+Split.y;
          #if ShadowsSoft == 1
           sincos((Noise+float4(2.0,3.0,4.0,5.0))*2.4,DiskSin,DiskCos);
           Disk1=float4(DiskSin.x,DiskCos.x,DiskSin.y,DiskCos.y)*ShadowBlurSplit[Splits]*ShadowBlur.xxyy;
           Disk2=float4(DiskSin.z,DiskCos.z,DiskSin.w,DiskCos.w)*ShadowBlurSplit[Splits]*ShadowBlur.zzww;
          #endif
	  float Depth=dot(IN.WorldPos.xyz-float3(ShadowPositionX[Splits],ShadowPositionY[Splits],ShadowPositionZ[Splits]),ShadowDirection)/ShadowRanges[Splits];
	  float2 ShadowProj=0.5+mul(float4(ShadowProjPos[Splits]+Normals*2.5,1.0),ShadowProjection/ShadowRanges[Splits]*2.0)*float2(0.5,-0.5);
          #if ShadowsSoft == 0
           float Shadow=step(saturate(Depth),tex2Dlod(Shadow1Sampler,ShadowProj.xyyy)[Splits])*IN.Tex.z;
          #else
           float Shadow=ShadowMapping(Shadow1Sampler,ShadowProj.xyxy+Disk1,ShadowProj.xyxy+Disk2,saturate(Depth),Splits)*IN.Tex.z;
          #endif
          Lighting *=Shadow;
          IN.Reflect.w *=Shadow;
         #endif
         #if Specularity == 1
          LightSpecular +=SpecularLight(LightDirection+ViewVec,Normals,Distribution)*Lighting;
         #endif
         Tiles=TileCount(IN.Project*float2(0.0625,0.03125),ViewDepth/LightingRange.x);
         for(int i=0; i<Tiles.x; i++ ) {
          float TileArray=TileArray(i+128.0,Index,Tiles.y);
          float2x3 Light=PixelLighting(TileArray,WorldCamPos,Normals,ViewVec,Distribution,Disk2,Disk1);
          Lighting +=Light[0], LightSpecular +=Light[1];
         }
         Lighting +=IN.Ambient.xyz;
         Lighting *=(1.0-Specular)*(1.0-NormalMap.x)*Diffuse.xyz;
         Lighting +=LightSpecular*Specular+(Diffuse.xyz*Secondarys.x*32.0);
	 Lighting +=pow(Diffuse.xyz,0.4545)*IN.Reflect.w*Secondarys.z*LightDirectionColor;
         return float4(lerp(Lighting*Secondarys.y*IN.Ambient.w,float3(IN.TBNRow1.w,IN.TBNRow2.w,IN.TBNRow3.w),IN.ViewVec.w),ceil(Diffuse.w-0.25)*ViewDepth*0.5);
      }
   float4 PS_DepthMapDir(Out_Depth IN) : COLOR
      {
         return float4(0.004+(dot(IN.Depth,ShadowDirection)/ShadowPosition.w).xxx,tex2D(BaseSampler,IN.Tex).w);
      }
   float4 PS_DepthMap(Out_Depth IN) : COLOR
      {
         return (0.004+saturate(length(IN.Depth/ShadowPosition.w)).xxxx)*ceil(tex2D(BaseSampler,IN.Tex.xy).w-0.25);
      }

//--------------
// techniques   
//--------------
   technique Lighting
      {
         pass p1
      {
         vertexShader = compile vs_3_0 VS_Lighting();
         pixelShader  = compile ps_3_0 PS_Lighting();
         AlphaBlendEnable=false;
         AlphaRef=0;
      }
      }
   technique DepthMap1
      {
         pass p1
      {
         VertexShader = compile vs_3_0 VS_DepthMapDir();
         PixelShader  = compile ps_3_0 PS_DepthMapDir();
         AlphaBlendEnable=false;
         AlphaRef=64;
         ColorWriteEnable=1;
      }
      }
   technique DepthMap2
      {
         pass p1
      {
         VertexShader = compile vs_3_0 VS_DepthMapDir();
         PixelShader  = compile ps_3_0 PS_DepthMapDir();
         AlphaBlendEnable=false;
         AlphaRef=64;
         ColorWriteEnable=2;
      }
      }
   technique DepthMap3
      {
         pass p1
      {
         VertexShader = compile vs_3_0 VS_DepthMapDir();
         PixelShader  = compile ps_3_0 PS_DepthMapDir();
         AlphaBlendEnable=false;
         AlphaRef=64;
         ColorWriteEnable=4;
      }
      }
   technique DepthMap4
      {
         pass p1
      {
         VertexShader = compile vs_3_0 VS_DepthMap();
         PixelShader  = compile ps_3_0 PS_DepthMap();
         AlphaBlendEnable=false;
         AlphaRef=0;
         ColorWriteEnable=1;
      }
      }
   technique DepthMap5
      {
         pass p1
      {
         VertexShader = compile vs_3_0 VS_DepthMap();
         PixelShader  = compile ps_3_0 PS_DepthMap();
         AlphaBlendEnable=false;
         AlphaRef=0;
         ColorWriteEnable=2;
      }
      }
   technique DepthMap6
      {
         pass p1
      {
         VertexShader = compile vs_3_0 VS_DepthMap();
         PixelShader  = compile ps_3_0 PS_DepthMap();
         AlphaBlendEnable=false;
         AlphaRef=0;
         ColorWriteEnable=4;
      }
      }
   technique DepthMap7
      {
         pass p1
      {
         VertexShader = compile vs_3_0 VS_DepthMap();
         PixelShader  = compile ps_3_0 PS_DepthMap();
         AlphaBlendEnable=false;
         AlphaRef=0;
         ColorWriteEnable=8;
      }
      }
